//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

namespace SID_monitor
{
    static class RRDTool
    {
        /// <summary>
        /// Gets the last database update time of the given RRDTool database
        /// </summary>
        public static SIDMonitorDateTime getLastDatabaseUpdateTime(string filename, IntPtr outputTextBoxHandle)
        {
            try // we check the string represents a valid time
            {
                String lastDatabaseUpdateUnixTime = RRDToolConnection.ExecuteRRDTool(RRDTool.CreateRRDToolLastCommand(filename), RRDToolProcess.ShowOptions.ErrorsOnly, outputTextBoxHandle);
                SIDMonitorDateTime lastDatabaseUpdateTime = new SIDMonitorDateTime(Convert.ToUInt64(lastDatabaseUpdateUnixTime));
                return lastDatabaseUpdateTime;
            }
            catch
            {
                throw;
            }
        }

        /// <summary>
        /// The RRDTool command for determining last database update time for the given database filename
        /// </summary>
        private static string CreateRRDToolLastCommand(string filename)
        {
            string RRDCommand = string.Empty;

            RRDCommand = "last \"" + filename + "\" ";

            return RRDCommand;
        }

        /// <summary>
        /// Gets the first database update time of the given RRDTool database
        /// </summary>
        public static SIDMonitorDateTime getFirstDatabaseUpdateTime(string filename, IntPtr outputTextBoxHandle)
        {
            try // we check the string represents a valid time
            {
                String firstDatabaseUpdateUnixTime = RRDToolConnection.ExecuteRRDTool(RRDTool.CreateRRDToolFirstCommand(filename), RRDToolProcess.ShowOptions.ErrorsOnly, outputTextBoxHandle);
                SIDMonitorDateTime firstDatabaseUpdateTime = new SIDMonitorDateTime(Convert.ToUInt64(firstDatabaseUpdateUnixTime));
                return firstDatabaseUpdateTime;
            }
            catch
            {
                throw;
            }
        }

        /// <summary>
        /// The RRDTool command for determining start time of the database
        /// </summary>
        private static string CreateRRDToolFirstCommand(string filename)
        {
            string RRDCommand = string.Empty;

            RRDCommand = "first \"" + filename + "\" ";

            return RRDCommand;
        }

    }
}
